unit utils;

interface

uses   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TUtils = class(TForm)
    Function Slashsep (Name,rest:String):String;  
    Function FileTypOK(TheFileName, Mask:String):Boolean;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation


Function TUtils.FileTypOK(TheFileName, Mask:String):Boolean;
Var IMask, IFile : Integer;
    MaskArray : Array of String;
    FileArray : Array of String;
    s:String;

begin
  Result:=False;
  IMask := 0;
  while pos('.',Mask)>0 do
  begin
    SetLength(MaskArray, IMask+1);
    MaskArray[IMask] := copy(Mask,1,Pos('.',Mask)-1);
    Mask := copy (Mask,Pos('.',Mask)+1,(Length(Mask)-Pos('.',Mask)+1));
    inc(IMask);
  end;
  SetLength(MaskArray, IMask+1);
  MaskArray[IMask] := copy(Mask,1,Length(Mask));

  IFile := 0;
  while pos('.',TheFileName)>0 do
  begin
    SetLength(FileArray, IFile+1);
    FileArray[IFile] := copy(TheFileName,1,Pos('.',TheFileName)-1);
    TheFileName := copy (TheFileName,Pos('.',TheFileName)+1,(Length(TheFileName)-Pos('.',TheFileName)+1));
    inc(IFile);
  end;
  SetLength(FileArray, IFile+1);
  FileArray[IFile] := copy(TheFileName,1,Length(TheFileName));

  if (IFile>IMask) and (copy (MaskArray[IMask],length(MaskArray[IMask]),1)<>'*') then exit;

  if (IFile<IMask) then exit;

  while IMask>-1 do
  Begin
    if pos(FileArray[IMask],MaskArray[IMask])=0 then
    begin
      if pos('*',MaskArray[IMask])=0 then exit;
      S:= copy(MaskArray[IMask],1,pos('*',MaskArray[IMask])-1);
      if not (Comparetext(UpperCase(copy(FileArray[IMask],1,Length(s))),UpperCase(S))=0) then exit;
      S:= copy(MaskArray[IMask], pos('*',MaskArray[IMask])+1, length(MaskArray[IMask])-pos('*',MaskArray[IMask]));
      if not (Comparetext(UpperCase(copy(FileArray[IMask],(Length(FileArray[IMask])-Length(S))+1,length(S))),UpperCase(S))=0) then exit;
    end else
      if not Comparetext(FileArray[IMask],MaskArray[IMask])=0 then exit;
    dec(IMask);
  end;
  Result:=True;
end;

Function TUtils.Slashsep(Name,Rest:String):String;
begin
  if Name[length(Name)] = '\'
  then Slashsep:=Name+Rest
  else Slashsep:=Name+'\'+Rest;
end;

end.

