unit fmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, utils, FileCtrl;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    searchndestrBtn: TButton;
    OldEdit: TEdit;
    NewEdit: TEdit;
    Label3: TLabel;
    RekurChkBox: TCheckBox;
    Label2: TLabel;
    Panel2: TPanel;
    Memo1: TMemo;
    PathEdit: TEdit;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    StatusBar: TStatusBar;
    FilesEdit: TEdit;
    Label4: TLabel;
    CasesensitiveChkBox: TCheckBox;
    LowerLinksChkBox: TCheckBox;
    lowerFilenamesChkBox: TCheckBox;
    ChPathCheckBox: TCheckBox;
    SpeedButton2: TSpeedButton;
    Function ReplaceText (TheFile, OldText, NewText: String; LowerLinks, Casesensitive: Boolean):Integer;
    Function ReplaceInPath (Path, OldText, NewText: String; Recursiv, LowerLinks, Casesensitive: Boolean):Boolean;
    Function KillLastPath (S:String):string;
    procedure searchndestrBtnClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure LowerLinksChkBoxClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

const SELDIRHELP = 1000;

var
  MainForm: TMainForm;
  Utls: TUtils;

implementation

{$R *.DFM}

procedure TMainForm.searchndestrBtnClick(Sender: TObject);
begin
  if Pos(OldEdit.Text, NewEdit.Text)<>0 then
  begin
    showMessage ('Der zu Gesuchte String kommt im zu erstzenden vor. (leider ist diese Art des Ersetzens im Moment nicht mglich.)');
    exit;
  end;
  StatusBar.SimpleText:='0';
  ReplaceInPath (PathEdit.Text,                {Verzeichnis}
                 OldEdit.Text,                 {suche nach ...}
                 NewEdit.Text,                 {ersetze durch}
                 RekurChkBox.checked,          {in Unterverzeichnisse?}
                 LowerLinksChkBox.checked,     {nder Links (Kleinschrift)}
                 CasesensitiveChkBox.checked); {Gro-/Kleinschreibung beim Suchen beachten}
end;


// ************************************************************************
// * ReplaceInPath - die Hauptschleife                                    *
// * Dateien werden nacheinander abgearbeitet in Unterverzeichnisse wird, *
// * wenn "Recursiv=True" gewechselt.                                     *
// ************************************************************************
Function TMainForm.ReplaceInPath (Path, OldText, NewText: String;
                                  Recursiv, LowerLinks,
                                  Casesensitive: Boolean):Boolean;
Var DosError :integer;
    DirInfo  :TSearchRec;
    Error : Longbool;
begin
  {$I-} ChDir(Path); {$I+}
  if IOResult <> 0 then begin
    showmessage('Das Verzeichnis: '+Path+' konnte nicht gefunden werden!');
    exit;
  end;
  DosError := FindFirst('*.*',faAnyFile,DirInfo);
  while (DosError = 0) do
  begin
    if (DirInfo.Name <> '.') and (DirInfo.Name <> '..') then
    begin
      if ((dirinfo.attr = faDirectory) and (Recursiv))
      then
      begin {in Verzeichnis Wechseln}

        if ChPathCheckBox.checked then
        begin
          if CompareStr(DirInfo.Name, lowercase (DirInfo.Name))<>0 then
          begin
            Renamefile(Utls.SlashSep(Path,DirInfo.Name), lowercase(Utls.SlashSep(Path,DirInfo.Name)));
            // ist zwar keine Datei - geht aber trotzdem :)
            DirInfo.Name:=lowercase(DirInfo.Name);
          end;
        end;

        ReplaceInPath(Utls.SlashSep(Path,DirInfo.Name),{Verzeichnis}
                      OldText,                    {suche nach ...}
                      NewText,                    {ersetze durch}
                      Recursiv,                   {in Unterverzeichnisse?}
                      LowerLinks,                 {nder Links (Kleinschrift)}
                      LowerLinksChkBox.Checked);  {Gro-/Kleinschreibung beim Suchen beachten}
      end
      else
      begin {Datei Durchsuchen lassen und Text ersetzen lassen -> ReplaceText}
        If Utls.FileTypOK(DirInfo.Name, FilesEdit.Text) then
          ReplaceText((Utls.SlashSep(Path,DirInfo.Name)), OldText, NewText, LowerLinks, Casesensitive);
        Application.ProcessMessages;
      end;
    end;
    DosError := Findnext(DirInfo);
  end;
  FindClose(DirInfo);
  Result:=True;
end;


// ************************************************************************
// * ReplaceText - die Textersetzung                                      *
// * Datei Wird in das Memo geladen und anschlieend nach HTML Tags       *
// * durchsucht (wenn LowerLink) ansonsten wird OldText duch New Text ers.*
// ************************************************************************
Function TMainForm.ReplaceText (TheFile, OldText, NewText: String; LowerLinks, Casesensitive: Boolean):Integer;
Var SelPos,SelPos2, I, changed: Integer;
    ReplaceDialog: TReplaceDialog;
begin
  changed:=0;
  if lowerFilenamesChkBox.checked then
  begin
    if CompareStr(TheFile, lowercase (TheFile))<>0 then
    begin
      if not RenameFile(TheFile, lowercase (TheFile)) then
      begin
        ShowMessage ('Datei konnte nicht Kleingeschriben werden. Breche ab!');
        exit;
      end;
      TheFile:=lowercase(TheFile);
    end;
  end;
  Memo1.lines.LoadFromFile(TheFile);
  ReplaceDialog:=TReplaceDialog.Create(self);
  with ReplaceDialog do
  begin
    if LowerLinks then
    begin
      SelPos  := Pos('<', (memo1.lines.Text));
      SelPos2 := Pos('>', (memo1.lines.Text));
      while SelPos > 0 do
      begin
        memo1.SelStart  := SelPos ;
        memo1.SelLength := (SelPos2 - 1)-SelPos;
        if   (CompareStr(copy (uppercase(Memo1.SelText),1,6),uppercase('a href'))=0)
          or (CompareStr(copy (uppercase(Memo1.SelText),1,7),uppercase('img src'))=0)
          then
        begin
          Memo1.SelText   := lowercase (Memo1.SelText);
          StatusBar.SimpleText:=IntToStr(StrToInt(StatusBar.SimpleText)+1);
        end;

        memo1.SelStart  := SelPos -1 ;
        memo1.SelLength := 1;
        memo1.SelText   := '%ersetztes_KleinerZeichen%';
        inc(Changed);

        SelPos2 := Pos('>', (memo1.lines.Text));

        memo1.SelStart  := SelPos2 -1 ;
        memo1.SelLength := 1;
        memo1.SelText   := '%ersetztes_GrerZeichen%';
        inc(Changed);

        SelPos  := Pos('<', (memo1.lines.Text));
        SelPos2 := Pos('>', (memo1.lines.Text));
      end;
      Memo1.Lines.Savetofile(TheFile);
      MainForm.ReplaceText (TheFile, '%ersetztes_KleinerZeichen%', '<', false, LowerLinks);
      MainForm.ReplaceText (TheFile, '%ersetztes_GrerZeichen%', '>', false, LowerLinks);
      StatusBar.SimpleText:=IntToStr(StrToInt(StatusBar.SimpleText)-Changed);
    end else
    begin
      if casesensitive then
        SelPos := Pos(OldText, memo1.lines.Text)
      else
        SelPos := Pos(uppercase(OldText), uppercase(memo1.lines.Text));
      while SelPos > 0 do
      begin
        memo1.SelStart := SelPos - 1;
        memo1.SelLength := Length(OldText);
        memo1.SelText := NewText;
        if casesensitive then
          SelPos := Pos(OldText, memo1.lines.Text)
        else
          SelPos := Pos(uppercase(OldText), uppercase(memo1.lines.Text));
        StatusBar.SimpleText:=IntToStr(StrToInt(StatusBar.SimpleText)+1);
      end;
      Memo1.Lines.Savetofile(TheFile);
    end;
  end;
End;


// ************************************************************************
// * KillLastPath - von einem Pfad wird das letzte Unterverzeichnis       *
// * abgeschnitte. Da kein OpenDirectory gefunden.                        *
// ************************************************************************
function TMainForm.KillLastPath (S:String):string;
Begin
repeat
  s:=copy(s,1,Length(s)-1);
until copy (S,Length(S),1)='\';
s:=copy(s,1,Length(s)-1);
result:=s;
end;


procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  With TOpendialog.create(self) do
  begin
    Execute;
    PathEdit.Text:=killlastPath(FileName)
  end;
end;

procedure TMainForm.LowerLinksChkBoxClick(Sender: TObject);
var b: boolean;
begin
  b:=not LowerLinksChkBox.checked;
  Label2.enabled:=b;
  Label3.enabled:=b;
  OldEdit.enabled:=b;
  NewEdit.enabled:=b;
  CasesensitiveChkBox.enabled:=b;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  Dir: string;
begin
  Dir := 'C:\';
  if SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt],SELDIRHELP) then
    Label1.Caption := Dir;
end;

procedure TMainForm.SpeedButton2Click(Sender: TObject);
begin
  ShowMessage ('(c) 2000 - Kristian Mller  -  Kristian-M@Kristian-M.de');
end;

end.
